##PROJECT_GLOBAL_BEGIN
[Programs]
Count=1

[Misc Info]
Author=
Company=
Version=1.0
EditTime=50812
CyProVersion=3.2.2

[Protection]
Level=0
Password=
##PROJECT_GLOBAL_END

##PROGRAM_BEGIN_1
#PROJECT_OPTIONS_BEGIN
[Program]
Name=New Program

[VCP]
I2CPriority=5
SendSource=1
SendAlloc=1
ProtectWithPasswd=0
Password=
ScanOverrunStopsProgram=1
OutputRetentive=0
AutoStart=1
Com1Mode=1
Com1Baudrate=3
Com1Data=0
Com2Mode=1
Com2Baudrate=3
Com2Data=0
EthAbusEnable=1
EthModbusEnable=0
WANUrl=
PushEvent=0
PushUrl=
ModbusDelay=20
ModbusDeviceAddress=1
ModbusPLCDataModel=2
ModbusAddress=0
ModbusRegisterCount=1
ModbusCoilsArrayVar=
ModbusRegistersArrayVar=
PLCCoilVars=
PLCRegisterVars=
ModbusCoilAddresses=
ModbusRegisterAddresses=

[Misc Info]
MonitorHistorySpeed=10

[Hardware]
CPUUnit=10
VarAreaTyp0.7.0=0
VarAreaTyp0.7.1=0
VarAreaTyp0.7.2=0
VarAreaTyp0.7.3=0
VarAreaTyp0.7.4=0
VarAreaTyp0.7.5=0
Card1=27
Type1=0
NAD1=3000
VarPrefix1=lcd00_

[Net]
PrgDevice00=21005
CurrentNAD=21005

[Monitor01]
VarCount=16
VarName1=lcd00_general_error
VarBase1=1
VarValue1=0
VarColor1=-16777208
VarIndex1=0
VarName2=expected_devices
VarBase2=1
VarValue2=0
VarColor2=255
VarIndex2=1
VarName3=entry_level
VarBase3=1
VarValue3=0
VarColor3=255
VarIndex3=2
VarName4=search_retries
VarBase4=1
VarValue4=2
VarColor4=255
VarIndex4=3
VarName5=frame_retries
VarBase5=1
VarValue5=0
VarColor5=255
VarIndex5=4
VarName6=short_timeout
VarBase6=1
VarValue6=50
VarColor6=255
VarIndex6=5
VarName7=long_timeout
VarBase7=1
VarValue7=100
VarColor7=255
VarIndex7=6
VarName8=dali_initialize
VarBase8=1
VarValue8=0
VarColor8=255
VarIndex8=7
VarName9=dali_addressing_req
VarBase9=1
VarValue9=0
VarColor9=255
VarIndex9=8
VarName10=dali_adr_cancel_req
VarBase10=1
VarValue10=0
VarColor10=255
VarIndex10=9
VarName11=search_devices_req
VarBase11=1
VarValue11=0
VarColor11=255
VarIndex11=10
VarName12=delete_device
VarBase12=1
VarValue12=1
VarColor12=255
VarIndex12=11
VarName13=delete_device_req
VarBase13=1
VarValue13=0
VarColor13=255
VarIndex13=12
VarName14=dali_num_of_devices
VarBase14=1
VarValue14=3
VarColor14=-16777208
VarIndex14=13
VarName15=added_devices
VarBase15=1
VarValue15=1
VarColor15=0
VarIndex15=14
VarName16=search_address
VarBase16=2
VarValue16=16777215
VarColor16=-16777208
VarIndex16=15

[Monitor02]
VarCount=22
VarName1=change_address
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=change_address_step
VarBase2=1
VarValue2=5
VarColor2=0
VarIndex2=1
VarName3=new_address
VarBase3=1
VarValue3=10
VarColor3=0
VarIndex3=2
VarName4=old_address
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
VarName5=lcd00_dali_24bit
VarBase5=1
VarValue5=0
VarColor5=0
VarIndex5=4
VarName6=lcd00_dali_ans
VarBase6=1
VarValue6=-1
VarColor6=0
VarIndex6=5
VarName7=lcd00_dali_ext
VarBase7=1
VarValue7=0
VarColor7=0
VarIndex7=6
VarName8=lcd00_dali_adr
VarBase8=1
VarValue8=127
VarColor8=0
VarIndex8=7
VarName9=lcd00_dali_cmd
VarBase9=1
VarValue9=144
VarColor9=0
VarIndex9=8
VarName10=lcd00_dali_req
VarBase10=1
VarValue10=0
VarColor10=0
VarIndex10=9
VarName11=multiple_frames[0]
VarBase11=2
VarValue11=41749
VarColor11=0
VarIndex11=10
VarName12=multiple_frames[1]
VarBase12=2
VarValue12=896
VarColor12=0
VarIndex12=11
VarName13=multiple_frames[2]
VarBase13=2
VarValue13=5504
VarColor13=0
VarIndex13=12
VarName14=multiple_frames[3]
VarBase14=2
VarValue14=5410
VarColor14=0
VarIndex14=13
VarName15=multiple_frames[4]
VarBase15=2
VarValue15=2850
VarColor15=0
VarIndex15=14
VarName16=multiple_frames[5]
VarBase16=2
VarValue16=1314
VarColor16=0
VarIndex16=15
VarName17=multiple_frames[6]
VarBase17=1
VarValue17=0
VarColor17=0
VarIndex17=16
VarName18=multiple_frames[7]
VarBase18=1
VarValue18=0
VarColor18=0
VarIndex18=17
VarName19=multiple_frames[8]
VarBase19=1
VarValue19=0
VarColor19=0
VarIndex19=18
VarName20=multiple_frames[9]
VarBase20=1
VarValue20=0
VarColor20=0
VarIndex20=19
VarName21=multiple_frames_req
VarBase21=1
VarValue21=0
VarColor21=0
VarIndex21=20
VarName22=multiple_frames_nr
VarBase22=1
VarValue22=4
VarColor22=0
VarIndex22=21
#PROJECT_OPTIONS_END

#DMVARSLIST_BEGIN
#DMVARSLIST_END

#MASKS_BEGIN
#MASKS_END

#CODE_BEGIN
// AllocGroupList="User Variables", "I/O Variables", "Constants", "change_address"
var
  program_id: int; default=8532; // Identification number used for autodetect.
  cybro_nad: long; // Current cybro A-bus address.
  expected_devices: int; default=0; // If greater than zero, address search is repeated until the specified number of devices is found (0..64).
  frame_retries: int; default=0; // Number of retries for each DALI message (0..10). Zero means message is sent once.
  search_retries: int; default=2; // Number of address search retries (0..10). Zero means search is performed only once.
  entry_level: int; default=0; // Entry level for binary address search. Default is 0, range is 0 to 23. Greater number will lower down colisions, but also slow down the addressing process.
  short_timeout: int; default=50; // DALI timeout for messages with no answer, sending included [ms]. Default is 50ms, range is 30..90ms.
  long_timeout: int; default=100; // DALI timeout for messages which expect answer, sending included [ms]. Default is 100ms, range is 100..500ms.
  queries_repeated: int; // Actual number of repeated queries before the answer is received.
  search_address: long; // Actual 24 bit search address.
  dali_adr: int; // First byte of dali message.
  dali_data: int; // Second byte of dali message.
  dali_req: bool; // Request to send dali message.
  dali_answer: int; // Dali frame answer.
  answer_time: int; // Measured time from request to answer, including frame transmission [ms].
  dali_cmd_sel: bool; // Dali command following, else direct arc power.
  dali_initialize: bool; // When addressing procedure begins, delete all existing devices.
  dali_addressing_req: bool; // Request to start addressing procedure from scratch.
  dali_addressing_ack: bool; // Addressing finished.
  dali_adr_cancel_req: bool; // Request to stop addressing procedure.
  dali_num_of_devices: int; // Number of addressed devices in system.
  dali_busy: bool; // Basic dali engine interface.
  used_addresses: ARRAY[0..63] OF bool; // Inidicate occupied addresses (0-free, 1-used).
  device_type: ARRAY[0..63] OF int; // Dali device type.
  short_adr: int; // Short address for add to/remove from group (0..63).
  group_adr: int; // Group address for add to/remove from group (0..15).
  add_to_group_req: bool;
  remove_from_group_req: bool;
  param_adr: int; // Device address for parameter send.
  param_adr_select: int; // Address type for parameter send: 0-short address, 1-group address, 2-broadcast.
  fade_time: int; // Values 0..15 (<0.7 .. 90.5s).
  fade_time_req: bool;
  fade_rate: int; // Values 1..15 (358 .. 2.8 steps/s).
  fade_rate_req: bool;
  min_level: int; // Values 0..254 (0..100%).
  min_level_req: bool;
  max_level: int; // Values min_level..254 (min_level..100%).
  max_level_req: bool;
  power_on_level: int; // Values min_level..254 (min_level..100%).
  power_on_level_req: bool;
  system_failure: int; // Values min_level..254 (min_level..100%).
  system_failure_req: bool;
  multiple_frames: ARRAY[0..15] OF long; // Buffer of frames for multiple send.
  multiple_frames_nr: int; // Number of frames for multiple send.
  multiple_frames_24bit: bool; // When set frames for multiple send are 24 bit long, otherwise 16.
  multiple_frames_req: bool; // Set to send multiple frames.
  multisend_busy: bool; // Multiple send executing. Wait until 0 to start new send.
  rpt_busy: bool; // Repeater executing. Wait until 0 to start new send.
  added_devices: int; // Number devices added in system in current addressing procedure.
  search_devices_req: bool; // Starts search for all addressed devices.
  delete_device: int; // Address of device to be unaddressed.
  delete_device_req: bool; // Starts deivce unaddress.
  ballast_level: ARRAY[0..63] OF int;
  ballast_level_req: ARRAY[0..63] OF bool;
  group_level: ARRAY[0..15] OF int;
  group_level_req: ARRAY[0..15] OF bool;
  broadcast_level: int;
  broadcast_level_req: bool;
  change_address_req: bool; // {AllocGroup="change_address"}
  old_address: int; // {AllocGroup="change_address"}
  new_address: int; // {AllocGroup="change_address"}
  change_address_step: int; // {AllocGroup="change_address"}
var_end;

function main:void; language 'Structured Text';
// AllocGroupList="User Variables"
var static
  ib: int;
  ig: int;
var_end;

  function dali_configurator:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var static
    dali_state: int; // Dali basic engine state machine, internal.
    dali_tout_cnt: int; // Dali basic engine timeout counter. Input also!
    dali_timeout_request: bool; // Dali basic engine Internal!
    dali_ans_req: bool; // Dali basic engine on answer received, output.
    dali_tout_req: bool; // Dali basic engine on timeout elapsed, output.
    dali_ans: int; // Dali basic engine received answer, output.
    rpt_state: int; // Repeater state machine, internal.
    rpt_adr_byte: int; // Repeater first send frame byte, input.
    rpt_data_byte: int; // Repeater second send frame byte, input.
    rpt_ext_byte: int; // Repeater third send frame byte, input.
    rpt_double: bool; // For obligatory doubled frames.
    rpt_len24: bool; // Dali-2 24 bit frame.
    rpt_send_req: bool; // Repeater send request, input.
    rpt_answer_req: bool; // Repeater on answer received request, output.
    rpt_end_req: bool; // Repeater end request. Repeatedly sent commands or queries without answer received, output.
    rpt_answer: int; // Repeater received answer, output.
    addr_state: int; // Dali addressing state.
    adr_byte_repeated: int;
    data_byte_repeated: int;
    repeated_req: bool;
    multisend_state: int; // Multiple send state machine, internal.
    adr_byte_via_dtr: int;
    data_byte_via_dtr: int;
    value_byte_via_dtr: int;
    via_dtr_adr_select: int;
    via_dtr_adr: int;
    via_dtr_req: bool;
    adr_byte_retried: int;
    data_byte_retried: int;
    send_retried_req: bool;
    used_addresses_ix: int;
    search_dev_again_req: bool;
    dali_adr_tout_cnt: int; // Valid addressing time of 15min timeout counter.
    dali_adr_tout_req: bool; // Addressing timeout request.
  var_end;

  var constant
    IDLE = 0;
    DALI_RECEIVE_STATE = 1; // Send and answer receive, actually.
    DALI_SETTLING_STATE = 2;
  var_end;

    function dali_addressing:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      search_addr_high: int; // Output search address.
      search_addr_mid: int; // Output search address.
      search_addr_low: int; // Output search address.
      short_address_index: int;
      retry_cntr: int;
      ix: int;
      step_size: long; // Search step size.
      linear_step_size: long;
      binary_search: bool; // 0-linear search, 1-binaey search
      linear_search_address: long; // Linear block search address is memorised during binary search.
    var_end;

    var constant
      ADDRESSING_TIMEOUT = 600; // Timeout in seconds. When expires, addressing enabled period is extended for next 15 minutes.
      ADDR_SEARCH_DEVICES_QUERY_STATE = 5;
      ADDR_SEARCH_DEVICES_STATE = 6;
      ADDR_INIT_ALL_STATE = 10;
      ADDR_INIT_UNADDRESSED_STATE = 11;
      ADDR_SHORT_UNADDR_STATE0 = 20;
      ADDR_SHORT_UNADDR_STATE1 = 21;
      ADDR_RMV_FGROUP_STATE0 = 30;
      ADDR_RMV_FGROUP_STATE1 = 31;
      ADDR_RMV_FGROUP_STATE2 = 32;
      ADDR_RAND_STATE = 110;
      ADDR_IF_TIMEOUT_STATE = 111;
      ADDR_START_SEARCH_STATE = 112;
      ADDR_LINEAR_SEARCH = 120;
      ADDR_SEARCH_OUT_STATE = 130;
      ADDR_COMPARE_STATE = 131;
      ADDR_BINARY_SEARCH = 132;
      ADDR_PROGRAM_STATE = 133;
      ADDR_QUERY_STATE = 134;
      ADDR_CHECK_STATE = 135;
      ADDR_WITHDRAW_STATE = 136;
      ADDR_DEVICE_TYPE_QUERY_STATE = 140;
      ADDR_DEVICE_TYPE_STATE = 141;
      ADDR_DEVICE_NOT_FOUND_STATE = 150;
      ADDR_TERMINATE_STATE = 160;
    var_end;

    var
      search_address_next: long;
      search_addr_out: int;
      i: int;
    var_end;

    begin
      /*******************************************************************************
              New initialization (addresses and device list will be re-created)
        - when finished, variables dali_num_of_devices and dali_addr_end_req are set.
        other option is: System extension (address previously unaddressed devices)
      *******************************************************************************/
      // 15 min max addressing period timeout
      if fp(clock_1s) then
        if dali_adr_tout_cnt>0 then
          dali_adr_tout_cnt:=dali_adr_tout_cnt-1;
          if dali_adr_tout_cnt<=0 then
            dali_adr_tout_req:=1;
          end_if;
        end_if;
      end_if;
      
      case addr_state of
      
        IDLE:
          if dali_addressing_req then
            dali_addressing_req:=0;
            if dali_initialize then
              addr_state:=ADDR_INIT_ALL_STATE;
            else
              used_addresses_ix:=0;
              search_dev_again_req:=0;
              dali_num_of_devices:=0;
              addr_state:=ADDR_SEARCH_DEVICES_QUERY_STATE;
            end_if;
          elsif search_devices_req then
              used_addresses_ix:=0;
              search_dev_again_req:=0;
              dali_num_of_devices:=0;
              addr_state:=ADDR_SEARCH_DEVICES_QUERY_STATE;
          end_if;
      
        ADDR_SEARCH_DEVICES_QUERY_STATE:
          if dali_adr_cancel_req then // cancel?
            dali_adr_cancel_req:=0;
            addr_state:=IDLE;
          elsif not rpt_busy and not multisend_busy then
            if used_addresses_ix<64 then
              dali_rpt_send((used_addresses_ix*2 or 16#01) and 16#7F,16#90,0,0,0); // QUERY STATUS
              addr_state:=ADDR_SEARCH_DEVICES_STATE;
            else
              if search_devices_req then
                search_devices_req:=0;
                addr_state:=IDLE;
              else
                addr_state:=ADDR_INIT_UNADDRESSED_STATE;
              end_if;
            end_if;
          end_if;
      
        ADDR_SEARCH_DEVICES_STATE:
          if not rpt_busy and not multisend_busy then
            if rpt_end_req then // .. timeout, no answer
              rpt_end_req:=0;
              if not search_dev_again_req then // try again
                search_dev_again_req:=1;
              else  // this is second query, next
                search_dev_again_req:=0;
                used_addresses[used_addresses_ix]:=0;
                used_addresses_ix:=used_addresses_ix+1;
              end_if;
              addr_state:=ADDR_SEARCH_DEVICES_QUERY_STATE;
            elsif rpt_answer_req then //.. response, add device
              rpt_answer_req:=0;
              used_addresses[used_addresses_ix]:=1;
              dali_num_of_devices:=dali_num_of_devices+1;
              used_addresses_ix:=used_addresses_ix+1;
              addr_state:=ADDR_SEARCH_DEVICES_QUERY_STATE;
            end_if;
          end_if;
      
        ADDR_INIT_UNADDRESSED_STATE:
          if not rpt_busy and not multisend_busy then
            // addressing init
            added_devices:=0;
            short_address_index:=0;
            dali_addressing_ack:=0;
            retry_cntr:=search_retries;
            // quadruple INITIALIZE (UNADDRESSED)
            multiple_frames[0]:=16#A5FF;
            multiple_frames[1]:=16#A5FF;
            multiple_frames[2]:=16#A5FF;
            multiple_frames[3]:=16#A5FF;
            multiple_frames_24bit:=0;
            multiple_frames_nr:=4;
            multiple_frames_req:=1;
            dali_adr_tout_cnt:=ADDRESSING_TIMEOUT;
            addr_state:=ADDR_RAND_STATE;
          end_if;
      
        ADDR_INIT_ALL_STATE:
          if not rpt_busy and not multisend_busy then
            for i:=0 to 64 do
              used_addresses[i]:=0;
            end_for;
            added_devices:=0;
            short_address_index:=0;
            dali_addressing_ack:=0;
            retry_cntr:=search_retries;
            // quadruple INITIALIZE (ALL)
            multiple_frames[0]:=16#A500;
            multiple_frames[1]:=16#A500;
            multiple_frames[2]:=16#A500;
            multiple_frames[3]:=16#A500;
            multiple_frames_24bit:=0;
            multiple_frames_nr:=4;
            multiple_frames_req:=1;
            dali_adr_tout_cnt:=ADDRESSING_TIMEOUT;
            addr_state:=ADDR_SHORT_UNADDR_STATE0;
          end_if;
      
        // unaddressing shorts
      
        ADDR_SHORT_UNADDR_STATE0:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#A3,16#FF,0,0,0); // DTR0=FF
            addr_state:=ADDR_SHORT_UNADDR_STATE1;
          end_if;
        ADDR_SHORT_UNADDR_STATE1:
          if dali_adr_cancel_req then // cancel?
            dali_adr_cancel_req:=0;
            addr_state:=ADDR_TERMINATE_STATE;
          elsif not rpt_busy and not multisend_busy then
            dali_rpt_send(16#FF,16#80,0,1,0); // SET SHORT ADDRESS (DTR0) (twice)
            dali_num_of_devices:=0;
            addr_state:=ADDR_RMV_FGROUP_STATE0;
          end_if;
      
        // remove from groups
      
        ADDR_RMV_FGROUP_STATE0:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#A3,16#80,0,0,0); // DTR0=80
            addr_state:=ADDR_RMV_FGROUP_STATE1;
          end_if;
        ADDR_RMV_FGROUP_STATE1:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#FF,16#23,0,1,0); // SET OPERATING MODE (DTR0) (twice)
            ix:=0;
            addr_state:=ADDR_RMV_FGROUP_STATE2;
          end_if;
        ADDR_RMV_FGROUP_STATE2:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#FF,ix or 16#70,0,1,0); // REMOVE FROM GROUP (twice)
            ix:=ix+1;
            if ix>15 then
              addr_state:=ADDR_RAND_STATE;
            end_if;
          end_if;
      
      // randomize and serach if any device
      
        ADDR_RAND_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#A7,16#00,0,1,0); // RANDOMIZE (twice)
            addr_state:=ADDR_IF_TIMEOUT_STATE;
          end_if;
      
        ADDR_IF_TIMEOUT_STATE:
          if not rpt_busy and not multisend_busy then
            if dali_adr_tout_req then // timeout
              dali_adr_tout_req:=0;
              addr_state:=ADDR_INIT_UNADDRESSED_STATE;
            else
              addr_state:=ADDR_START_SEARCH_STATE;
            end_if;
          end_if;
      
        ADDR_START_SEARCH_STATE:
          // ..... address search prepare .....
          step_size:=16#1000000;
          if entry_level>=1 and entry_level<=23 then // linear search first
            for i:=1 to entry_level do
              step_size:=step_size/2;
            end_for;
            linear_step_size:=step_size;
            binary_search:=0;
          else // entry_level==0, binary search
            binary_search:=1;
          end_if;
          search_address:=step_size-1;
          linear_search_address:=search_address;
          search_addr_high:=16#55; // to be different
          search_addr_mid:=16#55;
          search_addr_low:=16#55;
          addr_state:=ADDR_SEARCH_OUT_STATE;
      
        ADDR_LINEAR_SEARCH:
          if not rpt_busy and not multisend_busy then
            if rpt_end_req then       // ... timeout, no devices in the group ...
              rpt_end_req:=0;
              search_address:=search_address+step_size;
              if search_address>=16#1000000 then  // whole address space search finished
                addr_state:=ADDR_DEVICE_NOT_FOUND_STATE;
              else                                // next step
                addr_state:=ADDR_SEARCH_OUT_STATE;
              end_if;
            elsif rpt_answer_req then // response, device(s), start binary search
              rpt_answer_req:=0;
              step_size:=step_size/2;
              linear_search_address:=search_address;
              search_address:=search_address-step_size;
              binary_search:=1;
              addr_state:=ADDR_SEARCH_OUT_STATE;
            end_if;
          end_if;
      
        ADDR_SEARCH_OUT_STATE:
          if dali_adr_cancel_req then // cancel?
            dali_adr_cancel_req:=0;
            addr_state:=ADDR_TERMINATE_STATE;
          else
            if not rpt_busy and not multisend_busy then
              search_addr_out:=int((search_address and 16#FF0000) shr 16);
              if search_addr_high<>search_addr_out then
                search_addr_high:=search_addr_out;
                dali_rpt_send(16#B1,search_addr_high,0,0,0); // SEARCHADDRH
              end_if;
            end_if;
            if not rpt_busy and not multisend_busy then
              search_addr_out:=int((search_address and 16#FF00) shr 8);
              if search_addr_mid<>search_addr_out then
                search_addr_mid:=search_addr_out;
                dali_rpt_send(16#B3,search_addr_mid,0,0,0); // SEARCHADDRM
              end_if;
            end_if;
            if not rpt_busy and not multisend_busy then
              search_addr_out:=int(search_address and 16#FF);
              if search_addr_low<>search_addr_out then
                search_addr_low:=search_addr_out;
                dali_rpt_send(16#B5,search_addr_low,0,0,0); // SEARCHADDRL
              end_if;
            end_if;
            if not rpt_busy and not multisend_busy then
              addr_state:=ADDR_COMPARE_STATE;
            end_if;
          end_if;
      
        ADDR_COMPARE_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#A9,16#00,0,0,0); // COMPARE
            if binary_search then
              addr_state:=ADDR_BINARY_SEARCH;
            else
              addr_state:=ADDR_LINEAR_SEARCH;
            end_if;
          end_if;
      
        ADDR_BINARY_SEARCH:
          if not rpt_busy and not multisend_busy then
            if rpt_end_req then // timeout, no answer, random address greater then search address ...
              rpt_end_req:=0;
              if step_size==16#1000000 then  // entry level 0, first step, no device present
                addr_state:=ADDR_DEVICE_NOT_FOUND_STATE;
              elsif step_size==0 then  // asypthomatical exception
                search_address:=search_address+1;
                addr_state:=ADDR_SEARCH_OUT_STATE;
              else
                step_size:=step_size/2;
                search_address:=search_address+step_size;
                addr_state:=ADDR_SEARCH_OUT_STATE;
              end_if;
            elsif rpt_answer_req then // response, random address lower or equal then search address ...
              rpt_answer_req:=0;
              if step_size==0 then // address found!
                addr_state:=ADDR_PROGRAM_STATE;
              else
                step_size:=step_size/2;
                search_address:=search_address-step_size;
                addr_state:=ADDR_SEARCH_OUT_STATE;
              end_if;
            end_if;
          end_if;
      
        ADDR_PROGRAM_STATE:
          if not rpt_busy and not multisend_busy then
            short_address_index:=next_free_address(short_address_index);
            if short_address_index<>-1 then
              dali_rpt_send(16#B7,(short_address_index shl 1) or 16#1,0,0,0); // PROGRAM SHORT ADDRESS
              addr_state:=ADDR_QUERY_STATE;
            else // no free address available
              dali_addressing_ack:=1;
              addr_state:=ADDR_TERMINATE_STATE;
            end_if;
          end_if;
      
        ADDR_QUERY_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#BB,16#00,0,0,0); // QUERY SHORT ADDRESS
            addr_state:=ADDR_CHECK_STATE;
          end_if;
      
        ADDR_CHECK_STATE:
          if not rpt_busy and not multisend_busy then
            if rpt_end_req then // timeout, no answer, no short address verify answer
              rpt_end_req:=0;
              addr_state:=ADDR_DEVICE_NOT_FOUND_STATE;
            elsif rpt_answer_req then //.......... response ...........
              rpt_answer_req:=0;
              if dali_ans==((short_address_index shl 1) or 16#1) then
                used_addresses[short_address_index]:=1;
                dali_num_of_devices:=dali_num_of_devices+1;
                added_devices:=added_devices+1;
                addr_state:=ADDR_WITHDRAW_STATE;
              else // error bad short address verify answer
                addr_state:=ADDR_DEVICE_NOT_FOUND_STATE;
              end_if;
            end_if;
          end_if;
      
        ADDR_WITHDRAW_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#AB,16#00,0,0,0); // WITHDRAW
            addr_state:=ADDR_DEVICE_TYPE_QUERY_STATE;
          end_if;
      
        ADDR_DEVICE_TYPE_QUERY_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send((short_address_index)*2 or 16#1,16#99,0,1,0); // QUERY DEVICE TYPE (twice, todo: better !!!)
            addr_state:=ADDR_DEVICE_TYPE_STATE;
          end_if;
      
        ADDR_DEVICE_TYPE_STATE:
          if not rpt_busy and not multisend_busy then
            if rpt_end_req then       // .. timeout, no answer
              rpt_end_req:=0;
              device_type[short_address_index]:=-1; // todo: delete device? !!!
            elsif rpt_answer_req then // ........... response ............
              rpt_answer_req:=0;
              device_type[short_address_index]:=dali_ans;
            end_if;
            // ADDRESS DEVICE FOUND AND TYPE READ, GO NEXT DEVICE SEARCH
            if entry_level>=1 and entry_level<=23 then // continue linear search
              step_size:=linear_step_size;
              search_address:=linear_search_address;
              binary_search:=0;
            else // binary search again
              step_size:=16#1000000;
              search_address:=step_size-1;
            end_if;
            addr_state:=ADDR_SEARCH_OUT_STATE;
          end_if;
      
        ADDR_DEVICE_NOT_FOUND_STATE:
          if retry_cntr<=0 then  // ..................... no more retries ......................
            if expected_devices<=0 then             // not expected devices defined
              dali_addressing_ack:=1;               // addressing finished
              addr_state:=ADDR_TERMINATE_STATE;
            else                                    // ....... excpected defined .......
              if dali_num_of_devices<expected_devices then  // expected achieved?
                addr_state:=ADDR_RAND_STATE;                // no, try again with new randomize
              else                                          // yes
                dali_addressing_ack:=1;                     // addressing finished
                addr_state:=ADDR_TERMINATE_STATE;
              end_if;
            end_if;
          else // .......................................... retry ............................
            retry_cntr:=retry_cntr-1;
            addr_state:=ADDR_IF_TIMEOUT_STATE;
          end_if;
      
        ADDR_TERMINATE_STATE:
          if not rpt_busy and not multisend_busy then
            dali_rpt_send(16#A1,16#00,0,1,0); // TERMINATE (twice)
            dali_adr_tout_cnt:=0;
            addr_state:=IDLE;
          end_if;
      
        else
          addr_state:=IDLE;
      
      end_case;
      
    end;
    function dali_configuring:void; language 'Structured Text';
    begin
      /*******************************************************************************
                                   configuring groups, ballasts
      *******************************************************************************/
      
      // groups
      
      if add_to_group_req and not rpt_busy then
        add_to_group_req:=0;
        dali_rpt_send((short_adr*2) or 16#1,16#60 or group_adr,0,1,0); // INITIALIZE ALL
      end_if;
      
      if remove_from_group_req and not rpt_busy then
        remove_from_group_req:=0;
        dali_rpt_send((short_adr*2) or 16#1,16#70 or group_adr,0,1,0); // INITIALIZE ALL
      end_if;
      
      // ballast parameters
      
      // max level
      
      if max_level_req and not rpt_busy and not multisend_busy then
        max_level_req:=0;
        multiple_frames[0]:=max_level or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2A;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2A; // group address
        else
          multiple_frames[1]:=16#FF2A;                                              // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      // min level
      
      if min_level_req and not rpt_busy and not multisend_busy then
        min_level_req:=0;
        multiple_frames[0]:=min_level or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2B;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2B; // group address
        else
          multiple_frames[1]:=16#FF2B;                                            // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      // system failure
      
      if system_failure_req and not rpt_busy and not multisend_busy then
        system_failure_req:=0;
        multiple_frames[0]:=system_failure or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2C;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2C; // group address
        else
          multiple_frames[1]:=16#FF2C;                                            // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      // power-on level
      
      if power_on_level_req and not rpt_busy and not multisend_busy then
        power_on_level_req:=0;
        multiple_frames[0]:=power_on_level or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2D;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2D; // group address
        else
          multiple_frames[1]:=16#FF2D;                                            // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      // fade time
      
      if fade_time_req and not rpt_busy and not multisend_busy then
        fade_time_req:=0;
        multiple_frames[0]:=fade_time or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2E;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2E; // group address
        else
          multiple_frames[1]:=16#FF2E;                                            // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      // fade rate
      
      if fade_rate_req and not rpt_busy and not multisend_busy then
        fade_rate_req:=0;
        multiple_frames[0]:=fade_rate or 16#A300;
        case param_adr_select of
          0: multiple_frames[1]:=((param_adr*2) or 16#1)*256 or 16#2F;            // short address
          1: multiple_frames[1]:=((param_adr*2) and 16#1E or 16#81)*256 or 16#2F; // group address
        else
          multiple_frames[1]:=16#FF2F;                                            // broadcast
        end_case;
        multiple_frames[2]:=multiple_frames[1]; // repeat
        multiple_frames_24bit:=0;
        multiple_frames_nr:=3;
        multiple_frames_req:=1;
      end_if;
      
      
      
      // change address
      
      if change_address_req and not rpt_busy and not multisend_busy then
        change_address_req:=0;
        multiple_frames[0]:=(new_address*2+1) or 16#A300;     //DTR0=new_address
        multiple_frames[1]:=((old_address*2+1) shl 8) or 16#80;       //set short address (DTR0)
        multiple_frames[2]:=multiple_frames[1];               // repeat
        multiple_frames[3]:=((new_address*2+1) shl 8) or 16#22;       //save persistent variables
        multiple_frames_24bit:=0;
        multiple_frames_nr:=4;
        multiple_frames_req:=1;
      end_if;
    end;
    function dali_frame_send(adr,data,ext:int; len24:bit):void; language 'Structured Text';
    begin
      /*******************************************************************************
                                  send dali command
        - can be called only when not dali_busy
      *******************************************************************************/
      
      lcd00_dali_adr:=adr and 16#FF;
      lcd00_dali_cmd:=data and 16#FF;
      lcd00_dali_ext:=ext and 16#FF;
      if len24 then
        lcd00_dali_24bit:=1;
      else
        lcd00_dali_24bit:=0;
      end_if;
      dali_ans_req:=0;
      dali_tout_req:=0;
      if query_cmd(lcd00_dali_adr,lcd00_dali_cmd) then
        dali_tout_cnt:=long_timeout;
        lcd00_dali_ans:=16#FFFF;
        dali_state:=DALI_RECEIVE_STATE;
      else
        dali_tout_cnt:=short_timeout;
        dali_state:=DALI_SETTLING_STATE;
      end_if;
      dali_busy:=1;
      lcd00_dali_req:=1;
      
    end;
    function dali_frame_repeater:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      rpt_counter: int;
      rpt_cnt: int; // Calculated number to repeat.
    var_end;

    var constant
      RPT_SEND = 1;
      RPT_WAIT = 2;
    var_end;

    begin
      /*******************************************************************************
                           send dali frame repeated frame_retries times
       Query frames are repeated until answer is received or up to frame_retries
      *******************************************************************************/
      
      case rpt_state of
        IDLE:
          if rpt_send_req then
            rpt_send_req:=0;
            if query_cmd(rpt_adr_byte,rpt_data_byte) then
              rpt_cnt:=frame_retries+1;
            else
              if rpt_double then
                rpt_cnt:=2*(frame_retries+1);
              else
                rpt_cnt:=frame_retries+1;
              end_if;
            end_if;
            rpt_end_req:=0;
            rpt_answer_req:=0;
            queries_repeated:=0;
            rpt_counter:=0;
            rpt_state:=RPT_SEND;
          end_if;
      
        RPT_SEND:
          if not dali_busy then
            if rpt_counter<rpt_cnt then
              if rpt_len24 then
                dali_frame_send(rpt_adr_byte,rpt_data_byte,rpt_ext_byte,1);
              else
                dali_frame_send(rpt_adr_byte,rpt_data_byte,rpt_ext_byte,0);
              end_if;
              rpt_counter:=rpt_counter+1;
              rpt_state:=RPT_WAIT;
            else
              rpt_end_req:=1;
              rpt_state:=IDLE;
            end_if;
          end_if;
      
        RPT_WAIT:
          if not dali_busy then     // dali state machine non-active/finished
            if dali_ans_req then    // ... answer received ...
              dali_ans_req:=0;
              rpt_answer:=dali_ans;
              dali_answer:=dali_ans; // interface
              queries_repeated:=rpt_cnt;
              rpt_answer_req:=1;
              rpt_state:=IDLE;
            else
              dali_tout_req:=0;
              rpt_state:=RPT_SEND;
            end_if;
          end_if;
      
        else
          rpt_state:=IDLE;
      end_case;
      
      if rpt_state==IDLE then
        rpt_busy:=0;
      else
        rpt_busy:=1;
      end_if;
      
    end;
    function dali_rpt_send(adr,data,ext:int; double,len24:bit):void; language 'Structured Text';
    begin
      /*******************************************************************************
                          prepare and start dali command using frame repeater
        note: call when not rpt_busy
      *******************************************************************************/
      
      rpt_adr_byte:=adr and 16#FF;;
      rpt_data_byte:=data and 16#FF;;
      rpt_ext_byte:=ext and 16#FF;;
      rpt_double:=double;
      rpt_len24:=len24;
      rpt_busy:=1;
      rpt_send_req:=1;
      rpt_state:=IDLE;
    end;
    function dali_multiple_send:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      i: int;
    var_end;

    var constant
      MULTI_SEND = 1;
      MULTI_WAIT = 2;
    var_end;

    begin
      /*******************************************************************************
                             send sequentially array of frames
       note: start when not rpt_busy
      *******************************************************************************/
      
      case multisend_state of
        IDLE:
          if multiple_frames_req then
            multiple_frames_req:=0;
            i:=0;
            multisend_state:=MULTI_SEND;
          end_if;
      
        MULTI_SEND:
          if not rpt_busy then
            if i<multiple_frames_nr then
              if multiple_frames_24bit then
                dali_rpt_send(int((multiple_frames[i] and 16#FF0000) shr 16),int((multiple_frames[i] and 16#FF00) shr 8),int(multiple_frames[i] and 16#FF),0,1);
              else
                dali_rpt_send(int((multiple_frames[i] and 16#FF00) shr 8),int(multiple_frames[i] and 16#FF),0,0,0);
              end_if;
              i:=i+1;
              multisend_state:=MULTI_WAIT;
            else
              multisend_state:=IDLE;
            end_if;
          end_if;
      
        MULTI_WAIT:
          if not rpt_busy then
            if rpt_end_req then
              rpt_end_req:=0;
              multisend_state:=MULTI_SEND;
            end_if;
          end_if;
      
        else
          multisend_state:=IDLE;
      end_case;
      
      if multisend_state==IDLE then
        multisend_busy:=0;
      else
        multisend_busy:=1;
      end_if;
      
    end;
    function dali_send_single_cmd(adr,data:int; s:bit):void; language 'Structured Text';
    begin
      /*******************************************************************************
                            send dali short-addressed message, wrapper
        - selector bit s defines data byte as 0-direct arc level 1-command
        - call only when not rpt_busy
      *******************************************************************************/
      
      dali_rpt_send(((adr shl 1) or int(s)) and 16#007F,data,0,0,0);
      
    end;
    function dali_send_group_cmd(adr,data:int; s:bit):void; language 'Structured Text';
    begin
      /*******************************************************************************
                         send dali group-addressed message, wrapper
        - selector bit s defines data byte as 0-direct arc level 1-command
        - call only when not rpt_busy
      *******************************************************************************/
      
      dali_rpt_send(((((adr and 16#000F) shl 1) or int(s) or 16#0080)) and 16#FF,data,0,0,0);
      
    end;
    function dali_set_scene(scene:int):void; language 'Structured Text';
    begin
      /*******************************************************************************
                                send dali set-scene message
        - call only when not rpt_busy
      *******************************************************************************/
      
      dali_rpt_send(scene and 16#0F,16#10,0,0,0);
      
    end;
    function query_cmd(adr,data:int):bit; language 'Structured Text';
    begin
      /*******************************************************************************
                                check if answer is expected
      *******************************************************************************/
      
      if (adr==16#A9 and data==00) or              // COMPARE
         (adr==16#BB and data==00) or              // QUERY SHORT ADDRESS
         ((adr and 16#1)==16#1 and data==16#90) or // QUERY STATUS
         ((adr and 16#1)==16#1 and data==16#99)    // QUERY DEVICE TYPE
         then
        result:=1;
      else
        result:=0;
      end_if;
      
    end;
    function abs_l(l:long):long; language 'Structured Text';
    begin
      
      // return absolute value of a long
      
      if l>=0 then
        result:=l;
      else
        result:=(-l);
      end_if;
      
    end;
    function next_free_address(start_address:int):int; language 'Structured Text';
    // AllocGroupList="User Variables"
    var
      found: bool;
      i: int;
      n: int;
    var_end;

    begin
      /*******************************************************************************
                          find next free address, starting from given
      *******************************************************************************/
      
      found:=NO;
      n:=64; // addresses available
      i:=start_address%64;
      result:=-1;
      
      while not found and n>0 do
        if used_addresses[i]==0 then
          found:=YES;
          result:=i;
        else
          n:=n-1;
          i:=(i+1)%64;
        end_if;
      end_while;
      
    end;
  begin
    /*******************************************************************************
                                  main functionality
    *******************************************************************************/
    
    // ... initialization ...
    
    if first_scan then
      addr_state:=IDLE;
      dali_state:=IDLE;
      rpt_state:=IDLE;
      multisend_state:=IDLE;
    end_if;
    
    // ... interface: dali send ...
    if not rpt_busy then
      if dali_req then
        dali_req:=0;
        dali_rpt_send(dali_adr,dali_data,0,0,0);
      end_if;
    end_if;
    
    // ... dali timeout ...
    
    if dali_tout_cnt>0 then
      dali_tout_cnt:=dali_tout_cnt-scan_time;
      if dali_tout_cnt<=0 then
        dali_timeout_request:=1;
      end_if;
    end_if;
    
    // ... dali basic engine ...
    
    case dali_state of
      IDLE:
          ;
    
      DALI_RECEIVE_STATE:
        if dali_timeout_request then
          dali_timeout_request:=0;
          dali_ans:=0;
          dali_tout_req:=1;
          dali_state:=IDLE;
        elsif lcd00_dali_ans<>16#FFFF then
          dali_ans:=lcd00_dali_ans;
          answer_time:=long_timeout-dali_tout_cnt;
          dali_ans_req:=1;
          dali_tout_cnt:=short_timeout;
          dali_state:=DALI_SETTLING_STATE;
        end_if;
    
      DALI_SETTLING_STATE:
        if dali_timeout_request then
          dali_timeout_request:=0;
          dali_state:=IDLE;
        end_if;
    
      else
        dali_state:=IDLE;
    end_case;
    
    if dali_state==IDLE then
      dali_busy:=0;
    else
      dali_busy:=1;
    end_if;
    
    dali_addressing();
    dali_configuring();
    dali_multiple_send();
    dali_frame_repeater();
    
  end;
begin
  /*****************************************************************************************
    Application:  CybroDaliConfigurator
    Requirements: Cybro-3/3H, LC-DC module (firmware v3300 or later)
  
    1. Autodetect Cybro, start program
    2. Open mini scada and autodetect controller
  *****************************************************************************************/
  
  /* set ballast level */
  if ballast_level_req[ib] then
    if not dali_req then
      dali_adr:=ib*2;
      dali_data:=(ballast_level[ib]*254)/100;
      dali_req:=1;
      ballast_level_req[ib]:=0;
    end_if;
  elsif used_addresses[ib] and ballast_level[ib]==-1 then
    ballast_level[ib]:=0;
  elsif !used_addresses[ib] and ballast_level[ib]<>-1 then
    ballast_level[ib]:=-1;
  else
    ib:=(ib+1)%64;
  end_if;
  
  /* set group level */
  if group_level_req[ig] then
    if not dali_req then
      dali_adr:=ig*2 or 16#80;
      dali_data:=(group_level[ig]*254)/100;
      dali_req:=1;
      group_level_req[ig]:=0;
    end_if;
  else
    ig:=(ig+1)%16;
  end_if;
  
  /* set broadcast level */
  if broadcast_level_req and not dali_req then
    dali_adr:=16#FE;
    dali_data:=(broadcast_level*254)/100;
    dali_req:=1;
    broadcast_level_req:=0;
  end_if;
  
  /* delete device */
  if delete_device_req and not rpt_busy and not multisend_busy then
    delete_device_req:=0;
    multiple_frames[0]:=16#A3FF; // DTR0=FF
    multiple_frames[1]:=((delete_device*2) or 16#1)*256 or 16#80; // SET SHORT ADDRESS (DTR0)
    multiple_frames[2]:=((delete_device*2) or 16#1)*256 or 16#80; // SET SHORT ADDRESS (DTR0)
    multiple_frames_24bit:=0;
    multiple_frames_nr:=3;
    multiple_frames_req:=1;
    used_addresses[delete_device]:=0;
  end_if;
  
  cybro_nad:=get_nad();
  dali_configurator();
  
end;
#CODE_END

#DESCRIPTION_BEGIN
#DESCRIPTION_END

##PROGRAM_END_1

